/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.bytecode;

import cuchaz.enigma.bytecode.accessors.ClassInfoAccessor;
import cuchaz.enigma.bytecode.accessors.ConstInfoAccessor;
import cuchaz.enigma.bytecode.accessors.MemberRefInfoAccessor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;

public class ConstPoolEditor {
    private static Method m_getItem;
    private static Method m_addItem;
    private static Method m_addItem0;
    private static Field m_items;
    private static Field m_cache;
    private static Field m_numItems;
    private static Field m_objects;
    private static Field m_elements;
    private static Method m_methodWritePool;
    private static Constructor<ConstPool> m_constructorPool;
    private ConstPool m_pool;

    static {
        try {
            m_getItem = ConstPool.class.getDeclaredMethod("getItem", Integer.TYPE);
            m_getItem.setAccessible(true);
            m_addItem = ConstPool.class.getDeclaredMethod("addItem", Class.forName("javassist.bytecode.ConstInfo"));
            m_addItem.setAccessible(true);
            m_addItem0 = ConstPool.class.getDeclaredMethod("addItem0", Class.forName("javassist.bytecode.ConstInfo"));
            m_addItem0.setAccessible(true);
            m_items = ConstPool.class.getDeclaredField("items");
            m_items.setAccessible(true);
            m_cache = ConstPool.class.getDeclaredField("itemsCache");
            m_cache.setAccessible(true);
            m_numItems = ConstPool.class.getDeclaredField("numOfItems");
            m_numItems.setAccessible(true);
            m_objects = Class.forName("javassist.bytecode.LongVector").getDeclaredField("objects");
            m_objects.setAccessible(true);
            m_elements = Class.forName("javassist.bytecode.LongVector").getDeclaredField("elements");
            m_elements.setAccessible(true);
            m_methodWritePool = ConstPool.class.getDeclaredMethod("write", DataOutputStream.class);
            m_methodWritePool.setAccessible(true);
            m_constructorPool = ConstPool.class.getDeclaredConstructor(DataInputStream.class);
            m_constructorPool.setAccessible(true);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public ConstPoolEditor(ConstPool pool) {
        this.m_pool = pool;
    }

    public void writePool(DataOutputStream out) {
        try {
            m_methodWritePool.invoke((Object)this.m_pool, out);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public static ConstPool readPool(DataInputStream in) {
        try {
            return m_constructorPool.newInstance(in);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public String getMemberrefClassname(int memberrefIndex) {
        return Descriptor.toJvmName((String)this.m_pool.getClassInfo(this.m_pool.getMemberClass(memberrefIndex)));
    }

    public String getMemberrefName(int memberrefIndex) {
        return this.m_pool.getUtf8Info(this.m_pool.getNameAndTypeName(this.m_pool.getMemberNameAndType(memberrefIndex)));
    }

    public String getMemberrefType(int memberrefIndex) {
        return this.m_pool.getUtf8Info(this.m_pool.getNameAndTypeDescriptor(this.m_pool.getMemberNameAndType(memberrefIndex)));
    }

    public ConstInfoAccessor getItem(int index) {
        Object entry;
        block3: {
            try {
                entry = m_getItem.invoke((Object)this.m_pool, index);
                if (entry != null) break block3;
                return null;
            }
            catch (Exception ex) {
                throw new Error(ex);
            }
        }
        return new ConstInfoAccessor(entry);
    }

    public int addItem(Object item) {
        try {
            return (Integer)m_addItem.invoke((Object)this.m_pool, item);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public int addItemForceNew(Object item) {
        try {
            return (Integer)m_addItem0.invoke((Object)this.m_pool, item);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public void removeLastItem() {
        try {
            HashMap cache = this.getCache();
            if (cache != null) {
                ConstInfoAccessor item = this.getItem(this.m_pool.getSize() - 1);
                cache.remove(item);
            }
            Object items = m_items.get(this.m_pool);
            Object[][] objects = (Object[][])m_objects.get(items);
            int numElements = (Integer)m_elements.get(items) - 1;
            int nth = numElements >> 7;
            int offset = numElements & 0x7F;
            objects[nth][offset] = null;
            m_elements.set(items, numElements);
            m_numItems.set(this.m_pool, (Integer)m_numItems.get(this.m_pool) - 1);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public HashMap getCache() {
        try {
            return (HashMap)m_cache.get(this.m_pool);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public void changeMemberrefNameAndType(int memberrefIndex, String newName, String newType) {
        try {
            Object item = this.getItem(memberrefIndex).getItem();
            HashMap cache = this.getCache();
            if (cache != null) {
                cache.remove(item);
            }
            new MemberRefInfoAccessor(item).setNameAndTypeIndex(this.m_pool.addNameAndTypeInfo(newName, newType));
            if (cache != null) {
                cache.put(item, item);
            }
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
        assert (newName.equals(this.getMemberrefName(memberrefIndex)));
        assert (newType.equals(this.getMemberrefType(memberrefIndex)));
    }

    public void changeClassName(int classNameIndex, String newName) {
        try {
            Object item = this.getItem(classNameIndex).getItem();
            HashMap cache = this.getCache();
            if (cache != null) {
                cache.remove(item);
            }
            new ClassInfoAccessor(item).setNameIndex(this.m_pool.addUtf8Info(newName));
            if (cache != null) {
                cache.put(item, item);
            }
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public static ConstPool newConstPool() {
        ConstPool pool = new ConstPool("a");
        ConstPoolEditor editor = new ConstPoolEditor(pool);
        int size = pool.getSize();
        int i = 0;
        while (i < size - 1) {
            editor.removeLastItem();
            ++i;
        }
        assert (pool.getSize() == 1);
        assert (editor.getItem(0) == null);
        assert (editor.getItem(1) == null);
        assert (editor.getItem(2) == null);
        assert (editor.getItem(3) == null);
        editor.getCache().clear();
        return pool;
    }

    public String dump() {
        StringBuilder buf = new StringBuilder();
        int i = 1;
        while (i < this.m_pool.getSize()) {
            buf.append(String.format("%4d", i));
            buf.append("   ");
            buf.append(this.getItem(i).toString());
            buf.append("\n");
            ++i;
        }
        return buf.toString();
    }
}

