/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.Lists;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.Translator;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;

public class MethodImplementationsTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 3781080657461899915L;
    private Translator m_deobfuscatingTranslator;
    private MethodEntry m_entry;

    public MethodImplementationsTreeNode(Translator deobfuscatingTranslator, MethodEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("entry cannot be null!");
        }
        this.m_deobfuscatingTranslator = deobfuscatingTranslator;
        this.m_entry = entry;
    }

    public MethodEntry getMethodEntry() {
        return this.m_entry;
    }

    public String getDeobfClassName() {
        return this.m_deobfuscatingTranslator.translateClass(this.m_entry.getClassName());
    }

    public String getDeobfMethodName() {
        return this.m_deobfuscatingTranslator.translate(this.m_entry);
    }

    @Override
    public String toString() {
        String methodName;
        String className = this.getDeobfClassName();
        if (className == null) {
            className = this.m_entry.getClassName();
        }
        if ((methodName = this.getDeobfMethodName()) == null) {
            methodName = this.m_entry.getName();
        }
        return String.valueOf(className) + "." + methodName + "()";
    }

    public void load(JarIndex index) {
        ArrayList nodes = Lists.newArrayList();
        for (String implementingClassName : index.getImplementingClasses(this.m_entry.getClassName())) {
            MethodEntry methodEntry = new MethodEntry(new ClassEntry(implementingClassName), this.m_entry.getName(), this.m_entry.getSignature());
            if (!index.containsObfBehavior(methodEntry)) continue;
            nodes.add(new MethodImplementationsTreeNode(this.m_deobfuscatingTranslator, methodEntry));
        }
        for (MethodImplementationsTreeNode node : nodes) {
            this.add(node);
        }
    }

    public static MethodImplementationsTreeNode findNode(MethodImplementationsTreeNode node, MethodEntry entry) {
        if (node.getMethodEntry().equals(entry)) {
            return node;
        }
        int i = 0;
        while (i < node.getChildCount()) {
            MethodImplementationsTreeNode foundNode = MethodImplementationsTreeNode.findNode((MethodImplementationsTreeNode)node.getChildAt(i), entry);
            if (foundNode != null) {
                return foundNode;
            }
            ++i;
        }
        return null;
    }
}

