/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.Lists;
import cuchaz.enigma.mapping.ClassEntry;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javassist.ByteArrayClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.Descriptor;

public class JarClassIterator
implements Iterator<CtClass> {
    private JarFile m_jar;
    private Iterator<JarEntry> m_iter;

    public JarClassIterator(JarFile jar) {
        this.m_jar = jar;
        ArrayList classEntries = Lists.newArrayList();
        Enumeration<JarEntry> entries = this.m_jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().endsWith(".class")) continue;
            classEntries.add(entry);
        }
        this.m_iter = classEntries.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.m_iter.hasNext();
    }

    @Override
    public CtClass next() {
        JarEntry entry = this.m_iter.next();
        try {
            return JarClassIterator.getClass(this.m_jar, entry);
        }
        catch (IOException | NotFoundException ex) {
            throw new Error("Unable to load class: " + entry.getName());
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static List<ClassEntry> getClassEntries(JarFile jar) {
        ArrayList classEntries = Lists.newArrayList();
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            classEntries.add(JarClassIterator.getClassEntry(entry));
        }
        return classEntries;
    }

    public static Iterable<CtClass> classes(final JarFile jar) {
        return new Iterable<CtClass>(){

            @Override
            public Iterator<CtClass> iterator() {
                return new JarClassIterator(jar);
            }
        };
    }

    public static CtClass getClass(JarFile jar, ClassEntry classEntry) {
        try {
            return JarClassIterator.getClass(jar, new JarEntry(String.valueOf(classEntry.getName()) + ".class"));
        }
        catch (IOException | NotFoundException ex) {
            throw new Error("Unable to load class: " + classEntry.getName());
        }
    }

    private static CtClass getClass(JarFile jar, JarEntry entry) throws IOException, NotFoundException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int totalNumBytesRead = 0;
        InputStream in = jar.getInputStream(entry);
        while (in.available() > 0) {
            int numBytesRead = in.read(buf);
            if (numBytesRead < 0) break;
            bos.write(buf, 0, numBytesRead);
            if ((totalNumBytesRead += numBytesRead) <= 0x100000) continue;
            throw new Error("Class file " + entry.getName() + " larger than 1 MiB! Something is wrong!");
        }
        String className = Descriptor.toJavaName((String)JarClassIterator.getClassEntry(entry).getName());
        ClassPool classPool = new ClassPool();
        classPool.appendSystemPath();
        classPool.insertClassPath((ClassPath)new ByteArrayClassPath(className, bos.toByteArray()));
        return classPool.get(className);
    }

    private static ClassEntry getClassEntry(JarEntry entry) {
        return new ClassEntry(entry.getName().substring(0, entry.getName().length() - ".class".length()));
    }
}

