/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.convert;

import com.beust.jcommander.internal.Lists;
import cuchaz.enigma.convert.ClassMatch;
import cuchaz.enigma.convert.ClassMatches;
import cuchaz.enigma.convert.MemberMatches;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.Type;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public class MatchesReader {
    public static ClassMatches readClasses(File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            ClassMatches matches = new ClassMatches();
            String line = null;
            while ((line = in.readLine()) != null) {
                matches.add(MatchesReader.readClassMatch(line));
            }
            return matches;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static ClassMatch readClassMatch(String line) throws IOException {
        String[] sides = line.split(":", 2);
        return new ClassMatch(MatchesReader.readClasses(sides[0]), MatchesReader.readClasses(sides[1]));
    }

    private static Collection<ClassEntry> readClasses(String in) {
        List entries = Lists.newArrayList();
        String[] stringArray = in.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            if ((className = className.trim()).length() > 0) {
                entries.add(new ClassEntry(className));
            }
            ++n2;
        }
        return entries;
    }

    public static <T extends Entry> MemberMatches<T> readMembers(File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            MemberMatches matches = new MemberMatches();
            String line = null;
            while ((line = in.readLine()) != null) {
                MatchesReader.readMemberMatch(matches, line);
            }
            return matches;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static <T extends Entry> void readMemberMatch(MemberMatches<T> matches, String line) {
        if (line.startsWith("!")) {
            T source = MatchesReader.readEntry(line.substring(1));
            matches.addUnmatchableSourceEntry(source);
        } else {
            String[] parts = line.split(":", 2);
            T source = MatchesReader.readEntry(parts[0]);
            T dest = MatchesReader.readEntry(parts[1]);
            if (source != null && dest != null) {
                matches.addMatch(source, dest);
            } else if (source != null) {
                matches.addUnmatchedSourceEntry(source);
            } else if (dest != null) {
                matches.addUnmatchedDestEntry(dest);
            }
        }
    }

    private static <T extends Entry> T readEntry(String in) {
        if (in.length() <= 0) {
            return null;
        }
        String[] parts = in.split(" ");
        if (parts.length == 3 && parts[2].indexOf(40) < 0) {
            return (T)new FieldEntry(new ClassEntry(parts[0]), parts[1], new Type(parts[2]));
        }
        assert (parts.length == 2 || parts.length == 3);
        if (parts.length == 2) {
            return (T)EntryFactory.getBehaviorEntry(parts[0], parts[1]);
        }
        if (parts.length == 3) {
            return (T)EntryFactory.getBehaviorEntry(parts[0], parts[1], parts[2]);
        }
        throw new Error("Malformed behavior entry: " + in);
    }
}

