/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.convert;

import com.beust.jcommander.internal.Maps;
import cuchaz.enigma.TranslatingTypeLoader;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.convert.ClassIdentity;
import cuchaz.enigma.convert.ClassNamer;
import cuchaz.enigma.mapping.ClassEntry;
import java.util.Map;
import java.util.jar.JarFile;
import javassist.CtClass;

public class ClassIdentifier {
    private JarIndex m_index;
    private ClassNamer.SidedClassNamer m_namer;
    private boolean m_useReferences;
    private TranslatingTypeLoader m_loader;
    private Map<ClassEntry, ClassIdentity> m_cache;

    public ClassIdentifier(JarFile jar, JarIndex index, ClassNamer.SidedClassNamer namer, boolean useReferences) {
        this.m_index = index;
        this.m_namer = namer;
        this.m_useReferences = useReferences;
        this.m_loader = new TranslatingTypeLoader(jar, index);
        this.m_cache = Maps.newHashMap();
    }

    public ClassIdentity identify(ClassEntry classEntry) throws ClassNotFoundException {
        ClassIdentity identity = this.m_cache.get(classEntry);
        if (identity == null) {
            CtClass c = this.m_loader.loadClass(classEntry.getName());
            if (c == null) {
                throw new ClassNotFoundException(classEntry.getName());
            }
            identity = new ClassIdentity(c, this.m_namer, this.m_index, this.m_useReferences);
            this.m_cache.put(classEntry, identity);
        }
        return identity;
    }
}

