/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import com.google.common.collect.Lists;
import com.strobel.decompiler.languages.java.ast.CompilationUnit;
import cuchaz.enigma.Deobfuscator;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.SourceIndex;
import cuchaz.enigma.analysis.Token;
import cuchaz.enigma.mapping.Entry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.jar.JarFile;

public class TokenChecker {
    private Deobfuscator m_deobfuscator;

    protected TokenChecker(JarFile jarFile) throws IOException {
        this.m_deobfuscator = new Deobfuscator(jarFile);
    }

    protected String getDeclarationToken(Entry entry) {
        String source;
        CompilationUnit tree = this.m_deobfuscator.getSourceTree(entry.getClassName());
        SourceIndex index = this.m_deobfuscator.getSourceIndex(tree, source = this.m_deobfuscator.getSource(tree));
        Token token = index.getDeclarationToken(entry);
        if (token == null) {
            return null;
        }
        return source.substring(token.start, token.end);
    }

    protected Collection<String> getReferenceTokens(EntryReference<? extends Entry, ? extends Entry> reference) {
        CompilationUnit tree = this.m_deobfuscator.getSourceTree(reference.context.getClassName());
        String source = this.m_deobfuscator.getSource(tree);
        SourceIndex index = this.m_deobfuscator.getSourceIndex(tree, source);
        ArrayList values = Lists.newArrayList();
        for (Token token : index.getReferenceTokens(reference)) {
            values.add(source.substring(token.start, token.end));
        }
        return values;
    }
}

