/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import cuchaz.enigma.Deobfuscator;
import cuchaz.enigma.TestEntryFactory;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.mapping.ClassEntry;
import java.util.jar.JarFile;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class TestInnerClasses {
    private JarIndex m_index = new JarIndex();
    private Deobfuscator m_deobfuscator;
    private static final ClassEntry AnonymousOuter = TestEntryFactory.newClass("none/a");
    private static final ClassEntry AnonymousInner = TestEntryFactory.newClass("none/a$1");
    private static final ClassEntry SimpleOuter = TestEntryFactory.newClass("none/d");
    private static final ClassEntry SimpleInner = TestEntryFactory.newClass("none/d$a");
    private static final ClassEntry ConstructorArgsOuter = TestEntryFactory.newClass("none/c");
    private static final ClassEntry ConstructorArgsInner = TestEntryFactory.newClass("none/c$a");
    private static final ClassEntry AnonymousWithScopeArgsOuter = TestEntryFactory.newClass("none/b");
    private static final ClassEntry AnonymousWithScopeArgsInner = TestEntryFactory.newClass("none/b$1");
    private static final ClassEntry AnonymousWithOuterAccessOuter = TestEntryFactory.newClass("none/e");
    private static final ClassEntry AnonymousWithOuterAccessInner = TestEntryFactory.newClass("none/e$1");
    private static final ClassEntry ClassTreeRoot = TestEntryFactory.newClass("none/f");
    private static final ClassEntry ClassTreeLevel1 = TestEntryFactory.newClass("none/f$a");
    private static final ClassEntry ClassTreeLevel2 = TestEntryFactory.newClass("none/f$a$a");
    private static final ClassEntry ClassTreeLevel3 = TestEntryFactory.newClass("none/f$a$a$a");

    public TestInnerClasses() throws Exception {
        JarFile jar = new JarFile("build/testInnerClasses.obf.jar");
        this.m_index.indexJar(jar, true);
        this.m_deobfuscator = new Deobfuscator(jar);
    }

    @Test
    public void simple() {
        MatcherAssert.assertThat((Object)this.m_index.getOuterClass(SimpleInner), (Matcher)Matchers.is((Object)SimpleOuter));
        MatcherAssert.assertThat(this.m_index.getInnerClasses(SimpleOuter), (Matcher)Matchers.containsInAnyOrder((Object[])new ClassEntry[]{SimpleInner}));
        MatcherAssert.assertThat((Object)this.m_index.isAnonymousClass(SimpleInner), (Matcher)Matchers.is((Object)false));
        this.decompile(SimpleOuter);
    }

    @Test
    public void anonymous() {
        MatcherAssert.assertThat((Object)this.m_index.getOuterClass(AnonymousInner), (Matcher)Matchers.is((Object)AnonymousOuter));
        MatcherAssert.assertThat(this.m_index.getInnerClasses(AnonymousOuter), (Matcher)Matchers.containsInAnyOrder((Object[])new ClassEntry[]{AnonymousInner}));
        MatcherAssert.assertThat((Object)this.m_index.isAnonymousClass(AnonymousInner), (Matcher)Matchers.is((Object)true));
        this.decompile(AnonymousOuter);
    }

    @Test
    public void constructorArgs() {
        MatcherAssert.assertThat((Object)this.m_index.getOuterClass(ConstructorArgsInner), (Matcher)Matchers.is((Object)ConstructorArgsOuter));
        MatcherAssert.assertThat(this.m_index.getInnerClasses(ConstructorArgsOuter), (Matcher)Matchers.containsInAnyOrder((Object[])new ClassEntry[]{ConstructorArgsInner}));
        MatcherAssert.assertThat((Object)this.m_index.isAnonymousClass(ConstructorArgsInner), (Matcher)Matchers.is((Object)false));
        this.decompile(ConstructorArgsOuter);
    }

    @Test
    public void anonymousWithScopeArgs() {
        MatcherAssert.assertThat((Object)this.m_index.getOuterClass(AnonymousWithScopeArgsInner), (Matcher)Matchers.is((Object)AnonymousWithScopeArgsOuter));
        MatcherAssert.assertThat(this.m_index.getInnerClasses(AnonymousWithScopeArgsOuter), (Matcher)Matchers.containsInAnyOrder((Object[])new ClassEntry[]{AnonymousWithScopeArgsInner}));
        MatcherAssert.assertThat((Object)this.m_index.isAnonymousClass(AnonymousWithScopeArgsInner), (Matcher)Matchers.is((Object)true));
        this.decompile(AnonymousWithScopeArgsOuter);
    }

    @Test
    public void anonymousWithOuterAccess() {
        MatcherAssert.assertThat((Object)this.m_index.getOuterClass(AnonymousWithOuterAccessInner), (Matcher)Matchers.is((Object)AnonymousWithOuterAccessOuter));
        MatcherAssert.assertThat(this.m_index.getInnerClasses(AnonymousWithOuterAccessOuter), (Matcher)Matchers.containsInAnyOrder((Object[])new ClassEntry[]{AnonymousWithOuterAccessInner}));
        MatcherAssert.assertThat((Object)this.m_index.isAnonymousClass(AnonymousWithOuterAccessInner), (Matcher)Matchers.is((Object)true));
        this.decompile(AnonymousWithOuterAccessOuter);
    }

    @Test
    public void classTree() {
        MatcherAssert.assertThat((Object)this.m_index.containsObfClass(ClassTreeRoot), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.m_index.getOuterClass(ClassTreeRoot), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat(this.m_index.getInnerClasses(ClassTreeRoot), (Matcher)Matchers.containsInAnyOrder((Object[])new ClassEntry[]{ClassTreeLevel1}));
        ClassEntry fullClassEntry = new ClassEntry(String.valueOf(ClassTreeRoot.getName()) + "$" + ClassTreeLevel1.getInnermostClassName());
        MatcherAssert.assertThat((Object)this.m_index.containsObfClass(fullClassEntry), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.m_index.getOuterClass(ClassTreeLevel1), (Matcher)Matchers.is((Object)ClassTreeRoot));
        MatcherAssert.assertThat(this.m_index.getInnerClasses(ClassTreeLevel1), (Matcher)Matchers.containsInAnyOrder((Object[])new ClassEntry[]{ClassTreeLevel2}));
        fullClassEntry = new ClassEntry(String.valueOf(ClassTreeRoot.getName()) + "$" + ClassTreeLevel1.getInnermostClassName() + "$" + ClassTreeLevel2.getInnermostClassName());
        MatcherAssert.assertThat((Object)this.m_index.containsObfClass(fullClassEntry), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.m_index.getOuterClass(ClassTreeLevel2), (Matcher)Matchers.is((Object)ClassTreeLevel1));
        MatcherAssert.assertThat(this.m_index.getInnerClasses(ClassTreeLevel2), (Matcher)Matchers.containsInAnyOrder((Object[])new ClassEntry[]{ClassTreeLevel3}));
        fullClassEntry = new ClassEntry(String.valueOf(ClassTreeRoot.getName()) + "$" + ClassTreeLevel1.getInnermostClassName() + "$" + ClassTreeLevel2.getInnermostClassName() + "$" + ClassTreeLevel3.getInnermostClassName());
        MatcherAssert.assertThat((Object)this.m_index.containsObfClass(fullClassEntry), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.m_index.getOuterClass(ClassTreeLevel3), (Matcher)Matchers.is((Object)ClassTreeLevel2));
        MatcherAssert.assertThat(this.m_index.getInnerClasses(ClassTreeLevel3), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    private void decompile(ClassEntry classEntry) {
        this.m_deobfuscator.getSourceTree(classEntry.getName());
    }
}

