/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ConstructorEntry;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.Type;

public class TestEntryFactory {
    public static ClassEntry newClass(String name) {
        return new ClassEntry(name);
    }

    public static FieldEntry newField(String className, String fieldName, String fieldType) {
        return TestEntryFactory.newField(TestEntryFactory.newClass(className), fieldName, fieldType);
    }

    public static FieldEntry newField(ClassEntry classEntry, String fieldName, String fieldType) {
        return new FieldEntry(classEntry, fieldName, new Type(fieldType));
    }

    public static MethodEntry newMethod(String className, String methodName, String methodSignature) {
        return TestEntryFactory.newMethod(TestEntryFactory.newClass(className), methodName, methodSignature);
    }

    public static MethodEntry newMethod(ClassEntry classEntry, String methodName, String methodSignature) {
        return new MethodEntry(classEntry, methodName, new Signature(methodSignature));
    }

    public static ConstructorEntry newConstructor(String className, String signature) {
        return TestEntryFactory.newConstructor(TestEntryFactory.newClass(className), signature);
    }

    public static ConstructorEntry newConstructor(ClassEntry classEntry, String signature) {
        return new ConstructorEntry(classEntry, new Signature(signature));
    }

    public static EntryReference<FieldEntry, BehaviorEntry> newFieldReferenceByMethod(FieldEntry fieldEntry, String callerClassName, String callerName, String callerSignature) {
        return new EntryReference<FieldEntry, BehaviorEntry>(fieldEntry, "", TestEntryFactory.newMethod(callerClassName, callerName, callerSignature));
    }

    public static EntryReference<FieldEntry, BehaviorEntry> newFieldReferenceByConstructor(FieldEntry fieldEntry, String callerClassName, String callerSignature) {
        return new EntryReference<FieldEntry, BehaviorEntry>(fieldEntry, "", TestEntryFactory.newConstructor(callerClassName, callerSignature));
    }

    public static EntryReference<BehaviorEntry, BehaviorEntry> newBehaviorReferenceByMethod(BehaviorEntry behaviorEntry, String callerClassName, String callerName, String callerSignature) {
        return new EntryReference<BehaviorEntry, BehaviorEntry>(behaviorEntry, "", TestEntryFactory.newMethod(callerClassName, callerName, callerSignature));
    }

    public static EntryReference<BehaviorEntry, BehaviorEntry> newBehaviorReferenceByConstructor(BehaviorEntry behaviorEntry, String callerClassName, String callerSignature) {
        return new EntryReference<BehaviorEntry, BehaviorEntry>(behaviorEntry, "", TestEntryFactory.newConstructor(callerClassName, callerSignature));
    }
}

